#include <string>
using namespace std;
//--------------------------------
// Wisdom is used to manage
// a single word
//--------------------------------
class Wisdom
{
public:
  Wisdom() { word = NULL; }
  Wisdom(char* x) { word = x; }
  ~Wisdom() { delete [] word; }
  char* say() { return word; }
private:
  char* word;
};

//--------------------------------
// PersonKey is used to hold a key
// for the Person objects stored
// in the map.
//--------------------------------
class PersonKey
{
public:
  PersonKey() { key = ""; }
  PersonKey(string k) {
    key = k;
  }
  string getKey() { return key; }
private:
  string key;
};

bool operator<(PersonKey first, PersonKey second)
{
  return first.getKey() < second.getKey();
}

//----------------------------------
// Person is used to store the name
// of a person and any integer value
//----------------------------------
class Person
{
public:
  Person() {
    name = "EMPTY";
    number = 0;
  }
  Person(string x, int y) {
    name = x;
    number = y;
  }
  string getName()   { return name; }
  int    getNumber() { return number; }
private:
  string name;
  int    number;
};

